# Modern Website

A complete, modern, responsive website built with HTML, CSS, and JavaScript.

## Features

- **Responsive Design**: Works perfectly on all devices
- **Modern UI/UX**: Clean, professional design with smooth animations
- **Interactive Elements**: Animated cards, floating elements, and smooth transitions
- **Mobile Navigation**: Hamburger menu for mobile devices
- **Contact Form**: Functional contact form with validation
- **Modal System**: Popup modals for user interactions
- **Scroll Animations**: Elements animate as they come into view
- **Performance Optimized**: Throttled scroll events and efficient animations

## Files

- `index.html` - Main HTML file with semantic structure
- `style.css` - Modern CSS with responsive design and animations
- `app.js` - Interactive JavaScript features

## How to Use

1. Extract all files from the ZIP
2. Open `index.html` in your web browser
3. The website is ready to use!

## Technologies Used

- HTML5 semantic elements
- CSS3 with Flexbox and Grid
- Vanilla JavaScript (ES6+)
- Font Awesome icons
- Google Fonts (Inter)

## Browser Support

- Chrome 70+
- Firefox 65+
- Safari 12+
- Edge 79+

## Customization

The website is fully customizable:

- Colors can be changed in the CSS variables
- Content can be modified in the HTML file
- JavaScript functionality can be extended in app.js

## License

This project is open source and available under the MIT License.